﻿var cati = {
    context: $(".v-cati"),
    customColumns: [],
    initialize: function () {
        a4.callServerMethod(a4.getAction("GetInterviewersCustomColumns", "Home", "Project"), {}, function (result) {
            cati.customColumns = result;

            cati.initializeDataTables();
        });

        cati.bindEvents();
    },
    initializeDataTables: function () {
        $(".h-catiModulesTable", this.context).a4datatable({
            title: "Modules",
            ajaxAction: a4.getAction("GetStatisticsCATIModules", "Home", "Project"),
            columns: [
                { "Title": resources.Id, "Data": "Id", "Type": "numeric" },
                { "Title": resources.ModuleName, "Data": "Name", "HideInSelector": true },
                { "Title": resources.ProjectName, "Data": "ProjectName" },
                { "Title": resources.Cases, "Data": "Cases", "Type": "numeric" },
                { "Title": resources.Objective, "Data": "Objective", "Type": "numeric" },
                { "Title": resources.Completed, "Data": "Completed", "Type": "numeric" },
                { "Title": resources.Interviewers, "Data": "Interviewers", "Type": "numeric" },
                { "Title": resources.OnlineInterviewers, "Data": "OnlineInterviewers", "Type": "numeric" },
                { "Title": resources.Status, "Data": "StatusEnum", "Name": "Status", "Type": "enum" },
                { "Title": resources.LastUpdate, "Data": "LastUpdate", "Type": "datetime" }
            ],
            stateKey: "CATIModules",
            quickFilter: {
                "DisplayMode": "buttons",
                "Items": [
                    { "Label": resources.Stopped, "AjaxParams": { "status": 1 } },
                    { "Label": resources.Active, "AjaxParams": { "status": 3 } },
                    { "Label": resources.Paused, "AjaxParams": { "status": 2 } }
                ]
            },
            contextMenuItems: [
                {
                    "Action": "redirect",
                    "Params": { action: "Index", controller: "Quotas" },
                    "Label": resources.Quotas,
                    "DisplayCondition": function (data) { return voxco.security.has('USE_QUOTA_DEF', data.Permissions); }
                },
                {
                    "Action": "redirect",
                    "Params": { action: "Browse", controller: "Data" },
                    "Label": resources.Browse,
                    "DisplayCondition": function (data) { return voxco.security.has('USE_DATA_BROWSER', data.Permissions) }
                },
                {
                    "Action": "redirect",
                    "Params": { action: "Index", controller: "CallBacks" },
                    "Label": resources.Callbacks,
                    "DisplayCondition": function (data) { return voxco.security.has('USE_CB_ASGMNT', data.Permissions); }
                }
            ],
            contextMenuClick: function(event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                case "interviewers":
                    break;
                case "redirect":
                    if (data.params.action && data.params.controller)
                        window.location = a4.getProjectAction(data.params.action,
                            data.params.controller,
                            { projectId: row.ProjectId });
                    break;
                }
            },
            localizableTexts: { "All": resources.AllModules, "Search": resources.SearchModules }
        });

        var interviewersColumns = [
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "TalkTime", "Title": resources.TalkTime, "Data": "TalkTimeFormatted", "Type": "datetime" },
                { "Name": "WaitingTime", "Title": resources.WaitingTime, "Data": "WaitingTimeFormatted", "Type": "datetime" },
                { "Name": "PauseTime", "Title": resources.PauseTime, "Data": "PauseTimeFormatted", "Type": "datetime" },
                { "Name": "ReviewTime", "Title": resources.ReviewTime, "Data": "ReviewTimeFormatted", "Type": "datetime" },
                { "Name": "ConnectionTime", "Title": resources.ConnectionTime, "Data": "ConnectionTimeFormatted", "Type": "datetime" },
                { "Name": "LoginDateTime", "Title": resources.LoginDateTime, "Data": "LoginDateTime", "Type": "datetime" }
        ];

        _.each(cati.customColumns, function (element, index, list) {
            interviewersColumns.push({ "Name": "Custom" + (index + 1), "Title": element.Name });
        });

        $(".h-catiInterviewersTable", this.context).a4datatable({
            title: "Interviewers",
            ajaxAction: a4.getAction("GetStatisticsCATIInterviewers", "Home", "Project"),
            columns: interviewersColumns,
            stateKey: "CATIInterviewers",
            localizableTexts: { "Search": resources.SearchInterviewers }
        });
    },
    bindEvents: function () {
        cati.context.on("click", ".h-interviewersCustomColumns", function () {
            modalDialog.showWindow(a4.getAction("InterviewersCustomColumns", "Home", "Project", {}), 550, 750);
        });
    }
}

$(document).ready(function () {
    if (cati.context.length > 0) {
        cati.initialize();
    }
});